	subroutine INTERPOL2(Nx, Ny, Ns, Xmin, Ymin, Nxx, Nyy, xx, yy, &
				fx, gy, dx, dy, ix, iy, Sxy, ierror)
! 2D interpolation at all nodes of a rectangular element (x1,x2)*(y1,y2)

! s is species

	implicit none
	integer Nx, Ny, Ns, Nxx, Nyy, ix, iy, ierror
	real*8 Xmin, Ymin, dx, dy
	real*8 xx(Nxx), fx(Ns,Nxx), yy(Nyy), gy(Ns,Nyy), Sxy(4,Ns)

	integer i, k, m, s
	real*8 x1, x2, y1, y2, x(2), tol, xn(4), yn(4)
	real*8 v1(Ns), v2(Ns), v3(Ns), v4(Ns)

	tol = max(dx,dy) * 1.d-6	! geometric tolerance

! x1, x2, y1, y2
	x1 = dx * (ix-1) + Xmin
	y1 = dy * (iy-1) + Ymin
	x2 = x1 + dx
	y2 = y1 + dy

! nodal coordinates
	xn(1) = x1
	xn(2) = x2
	xn(3) = x2
	xn(4) = x1

	yn(1) = y1
	yn(2) = y1
	yn(3) = y2
	yn(4) = y2

! linear interpolation for the 4 nodes
	do k = 1,Nxx-1
	  do m = 1,Nyy-1
	    do i = 1,4
	      if( xn(i) .ge. xx(k)-tol .and. xn(i) .le. xx(k+1)+tol .and. &
	          yn(i) .ge. yy(m)-tol .and. yn(i) .le. yy(m+1)+tol ) then
! found - interpolate (k,m) interval

!!!!!!!!!!!!!!!!!!!!! from Mathematica !!!!!!!!!!!!!!!!!!!!!
! r = 2/(Xk2 - Xk1)*(x - Xk1) - 1
! s = 2/(Ym2 - Ym1)*(y - Ym1) - 1
! v = 1/4*(1-r)*(1-s)*v1 + 1/4*(1+r)*(1-s)*v2 + 1/4*(1+r)*(1+s)*v3 + 1/4*(1-r)*(1+s)*v4

!FullSimplify[v]
!((v3 x - v4 x - v3 Xk1 + v4 Xk2) (y - Ym1) - v2 (x - Xk1) (y - Ym2) + 
! v1 (x - Xk2) (y - Ym2))/((Xk1 - Xk2) (Ym1 - Ym2))
!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!

	        do s = 1, Ns
	          v1(s) = fx(s,k  ) * gy(s,m  )
	          v2(s) = fx(s,k+1)*  gy(s,m  )
	          v3(s) = fx(s,k+1)*  gy(s,m+1)
	          v4(s) = fx(s,k  )*  gy(s,m+1)

		  Sxy(i,s) = ( ( v3(s) * xn(i) - v4(s) * xn(i) - v3(s)        * &
			  xx(k  ) + v4(s) * xx(k+1) ) * ( yn(i) - yy(m  ) )   - &
			  v2(s) * ( xn(i) - xx(k  ) ) * ( yn(i) - yy(m+1) )   + &
			  v1(s) * ( xn(i) - xx(k+1) ) * ( yn(i) - yy(m+1) ) ) / &
			  ( ( xx(k  ) - xx(k+1) ) * ( yy(m  ) - yy(m+1) ) )
	        enddo	! s
	      endif
	    enddo	! i
	  enddo		! m
	enddo		! k

	return
	end
